/*******************************************************************
*
*  DESCRIPTION: Atomic Model Motor2
*
*  AUTHOR: Dieynaba Alpha Tall
*
*  EMAIL: alphadieynaba@yahoo.fr
*
*  DATE: 07/07/2009
*******************************************************************/

/** include files **/
#include <math.h>            // fabs( ... )
#include <stdlib.h>
#include "Motor.h"  // base header
#include "message.h"       // InternalMessage ....
#include "mainsimu.h"      // class MainSimulator
#include "strutil.h"       // str2float( ... )
#include "commonH.h"

/*******************************************************************
* Function Name: Motor2
* Description: constructor
********************************************************************/
Motor::Motor( const std::string &name ) : Atomic( name )
, motor_in( addInputPort( "motor_in" ) )
, motor_out( addOutputPort( "motor_out" ) )
, movePrepTime (00,00,00,10)
{
	std::string timepreparation( MainSimulator::Instance().getParameter( description(), "movePrepTime" ) ) ;
//test
	if (timepreparation !="") movePrepTime = timepreparation;

	//MainSimulator::Instance().Spin_Motor_Clockwise(30);

	cout<<"movePrepTime="<<movePrepTime<<"\n";
}

/*******************************************************************
* Function Name: MotorR::initFunction()
* Description: Initialization Function
********************************************************************/
Model &Motor::initFunction()
{
	state = STOP;		// stop
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: MotorR::externalFunction()
* Description: External Function MotorR
********************************************************************/
Model &Motor::externalFunction( const ExternalMessage &msg )
{
	cout << "--> In MOTOR ExtFunc() / state= " << state;
	
	if (msg.port() == motor_in)
	{	
		move_dir = static_cast <int> (msg.value());
		
		cout << "/ port= sctrl_start_in / value= " << move_dir;
		
		if (move_dir == COMMON_H::O_STOP)
		{
			state  = PREP_STOP;
			holdIn(Atomic::active, ZERO_TIME);
		}
		
		else if (move_dir == COMMON_H::O_GO_FWD)
		{
			if (state == STOP || state == MOVE_REV) {
				state = PREP_MOVE_FWD;
				holdIn(Atomic::active, movePrepTime);
			}
		}
		
		else if (move_dir==COMMON_H::O_GO_REV)
		{
			if (state == STOP || state == MOVE_FWD) {
				state = PREP_MOVE_REV;
				holdIn(Atomic::active, movePrepTime);
			}
		}
	}
	
	cout << "/ new state= " << state << "\n";
	
	return *this;
}

/*******************************************************************
* Function Name: MotorR::internalFunction()
* Description: Internal Function MotorR
********************************************************************/
Model &Motor::internalFunction( const InternalMessage & )
{
	cout << "<----- In MOTOR IntFunc() / state= " << state;
	
	if (state==PREP_MOVE_FWD){
		state=MOVE_FWD;
		passivate();
	}
	
	else if(state==PREP_MOVE_REV){
		state=MOVE_REV;
		passivate();
	}
	
	else if(state==PREP_STOP){
		state=STOP;
		passivate();
	}
	
	cout << "/ new state= " << state << "\n";
	
	return *this;
}

/*******************************************************************
* Function Name: MotorR::outputFunction()
* Description: Output function MotorR - writes info about time and events
********************************************************************/
Model &Motor::outputFunction( const InternalMessage &msg )
{
	cout << "<----- In MOTOR OutFunc() / state= " << state;
	
	if (state == PREP_MOVE_FWD){
		sendOutput( msg.time(), motor_out, COMMON_H::O_GO_FWD) ;//moving forward
		cout << "/ sent " << COMMON_H::O_GO_FWD << " to motor_out\n";
	}
	
	else if (state == PREP_MOVE_REV){
		sendOutput( msg.time(), motor_out, COMMON_H::O_GO_REV) ;//moving backward
		cout << "/ sent " << COMMON_H::O_GO_REV << " to motor_out\n";
	}
	
	else if (state == PREP_STOP){
		sendOutput( msg.time(), motor_out, COMMON_H::O_STOP) ;//stop
		cout << "/ sent " << COMMON_H::O_STOP << " to motor_out\n";
	}
	return *this ;
}

Motor::~Motor()
{
	//MainSimulator::Instance().Spin_Motor_Stop();
}
